//
//  MCNibLoadingView.h
//  MCApplication
//
//  Created by Michael Clark on 21/04/05.
//  Copyright 2005 Marketcircle Inc. All rights reserved.
//

#import <Cocoa/Cocoa.h>


@interface MCNibLoadingView : NSView {
	IBOutlet NSView*    contentView;

	BOOL             	_calledAwakeFromNib;

	NSMutableArray 		*_topLevelObjects;
	unsigned            __retainCountThreshold;
	BOOL            	__cleaningUp;
	BOOL				__didLocalize;
}

- (id)initWithFrame:(NSRect)frame preserveNIBFrameSize:(BOOL)flag;
- (id)initWithFrame:(NSRect)frame andNIBNamed: (NSString*)aNIBName;
- (id)initWithFrame:(NSRect)frame andNIBNamed: (NSString*)aNIBName preserveNIBFrameSize: (BOOL)flag;

// Optimization
- (BOOL)didAutoLocalize;
- (void)autoLocalize;

/*!
 Used by subclassers for any kind of version (solo, normal, pro) related adds or removes. Called during init after the nib is loaded and before autoLocalize. Default implementation does nothing.
 Added by AJ 2009-10-17.
 */
- (void)prepareForAppFlavor;


- (void)configureWithContentFrame;
- (void)configureWithContainerFrame;

- (NSMutableArray *)topLevelObjects;
- (void)setTopLevelObjects:(NSMutableArray *)aTopLevelObjects;

// for sub-subclassers to return a different nib name - especially useful when used in conjunction with IB customviews
// default returns classname
- (NSString *)nibLoadingViewNibName;

@end
